/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "CppActionTabPresenter.h"

#include "QtPropertyFieldEditor.h"
#include "TextFieldEditor.h"
#include "ExpandableFieldEditor.h"

// -------------------- constructor --------------------
CppActionTabPresenter::CppActionTabPresenter(CamiTKExtensionModelPresenter* presenter, VariantDataModel& dataModel, QWidget* parent) : ActionTabPresenter(presenter, dataModel, parent) {

    //-- advanced fields
    QWidget* expandableWidget = new QWidget();
    QGridLayout* expandableGridLayout = new QGridLayout(expandableWidget);
    expandableGridLayout->setContentsMargins(0, 0, 0, 0);

    QtPropertyFieldEditor* advancedQtPropertyFieldEditor;

    // in Python, custom is not supported (yet)
    QStringList guiType = {"Default Action GUI", "No GUI", "Custom GUI"};
    QString guiTypeDdescription = R"(You can choose between three types of user interface:<ul>
    <li>
        <b>Default Action GUI</b> will automatically build an interface for your action that will present the parameters to the user. Note that you can constrain to the parameter values (see the <i>Parameters</i> section below) and modify the default value or constraints depending on the currently selected target. This is the <i>easiest</i> way to start your development.
    </li>
    <li>
        <b>No GUI</b> means that your action does not require any user interface, when triggered it will immediately execute its <i>process</i> method.
    </li>
    <li>
        <b>Custom GUI</b> will setup a specific <i>getUI()</i> method where you can write your own code to create a specific user interface. If your UI is to be integrated in the action panel, leave the <i>Not Embedded</i> as is (unselected).
    </li>
    </ul>)";

    advancedQtPropertyFieldEditor = new QtPropertyFieldEditor(presenter, dataModel["gui"], "User Interface", guiTypeDdescription, "Default Action GUI");
    advancedQtPropertyFieldEditor->setEnumValues(guiType);
    advancedQtPropertyFieldEditor->appendRowTo(expandableGridLayout);

    advancedQtPropertyFieldEditor = new QtPropertyFieldEditor(presenter, dataModel["notEmbedded"], "Not Embedded", "<p>By default an action's widget is embedded. If you do not want to embed your action's widget, check this option.</p><p>When embedded, the action's widget will appear in the ActionViewer. When not embedded a new dialog will be created to hold the action's widget.</p><p>Unless you know what you are doing, leave this option to false</p>", false);
    advancedQtPropertyFieldEditor->appendRowTo(expandableGridLayout);

    TextFieldEditor* advancedTextFieldEditor;
    advancedTextFieldEditor = new TextFieldEditor(presenter, dataModel["headerIncludes"], "header includes", "C++ <tt>#include</tt> directives to add at the beginning of the generated Action class header.");
    advancedTextFieldEditor->setLanguage("cpp");
    advancedTextFieldEditor->appendRowTo(expandableGridLayout);

    advancedTextFieldEditor = new TextFieldEditor(presenter, dataModel["classMembers"], "class members", R"(<p>C++ source code to add to the class members.</p>
    <ul>
        <li>In <b>HotPlug</b> extensions, these lines will be added directly in the custom action source code. You cannot declare any public/private/protected/slots/signal sections, just additional declarations for local variables or methods.</li>
        <li>In <b>Standard</b> extensions, these lines will be added inside the generated action class header. Use these lines to declare additional required members (attributes, methods, signal/slots...).</li>
    </ul>
    <p><b>Note:</b> The source code generator will not be able to add the corresponding empty method blocks in the implementation files. If you declare methods here, you will have to add their blocks as well as their implementations in the corresponding action source code.</p>)");
    advancedTextFieldEditor->setLanguage("cpp");
    advancedTextFieldEditor->appendRowTo(expandableGridLayout);

    advancedTextFieldEditor = new TextFieldEditor(presenter, dataModel["implementationIncludes"], "implementation includes", "C++ <tt>#include</tt> directives to add at the beginning of the generated Action class source (required for example if you added class members).");
    advancedTextFieldEditor->setLanguage("cpp");
    advancedTextFieldEditor->appendRowTo(expandableGridLayout);

    ExpandableFieldEditor* advancedEditor = new ExpandableFieldEditor(presenter, expandableWidget, dataModel, "Advanced");
    advancedEditor->appendRowTo(actionTabLayout);
}
