/*
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * Copyright (C) 2018 Red Hat, Inc.
 */
import React from 'react';

import type { StoragePool } from '../../types';

import { DescriptionList, DescriptionListDescription, DescriptionListGroup, DescriptionListTerm } from "@patternfly/react-core/dist/esm/components/DescriptionList";

import { storagePoolId } from '../../helpers.js';
import cockpit from 'cockpit';

const _ = cockpit.gettext;

export const StoragePoolOverviewTab = ({ storagePool } : { storagePool: StoragePool }) => {
    const idPrefix = `${storagePoolId(storagePool.name, storagePool.connectionName)}`;

    return (
        <DescriptionList isHorizontal>
            { storagePool.source && storagePool.source.host && <DescriptionListGroup>
                <DescriptionListTerm> {_("Host")} </DescriptionListTerm>
                <DescriptionListDescription id={`${idPrefix}-host`}>
                    {storagePool.source.host.name}
                </DescriptionListDescription>
            </DescriptionListGroup> }

            { storagePool.source && storagePool.source.device && <DescriptionListGroup>
                <DescriptionListTerm> {_("Source path")} </DescriptionListTerm>
                <DescriptionListDescription id={`${idPrefix}-source-path`}> {storagePool.source.device.path} </DescriptionListDescription>
            </DescriptionListGroup> }

            { storagePool.source && storagePool.source.dir && <DescriptionListGroup>
                <DescriptionListTerm> {_("Source path")} </DescriptionListTerm>
                <DescriptionListDescription id={`${idPrefix}-source-path`}> {storagePool.source.dir.path} </DescriptionListDescription>
            </DescriptionListGroup> }

            { storagePool.source && storagePool.source.name && <DescriptionListGroup>
                <DescriptionListTerm> {_("Source")} </DescriptionListTerm>
                <DescriptionListDescription id={`${idPrefix}-source-path`}> {storagePool.source.name} </DescriptionListDescription>
            </DescriptionListGroup> }

            { storagePool.source && storagePool.source.format && <DescriptionListGroup>
                <DescriptionListTerm> {_("Source format")} </DescriptionListTerm>
                <DescriptionListDescription id={`${idPrefix}-source-format`}> {storagePool.source.format.type} </DescriptionListDescription>
            </DescriptionListGroup> }

            { storagePool.target && storagePool.target.path && <DescriptionListGroup>
                <DescriptionListTerm> {_("Target path")} </DescriptionListTerm>
                <DescriptionListDescription id={`${idPrefix}-target-path`}> {storagePool.target.path} </DescriptionListDescription>
            </DescriptionListGroup> }

            <DescriptionListGroup>
                <DescriptionListTerm> {_("Persistent")} </DescriptionListTerm>
                <DescriptionListDescription id={`${idPrefix}-persistent`}> {storagePool.persistent ? _("yes") : _("no")} </DescriptionListDescription>
            </DescriptionListGroup>

            {storagePool.persistent && <DescriptionListGroup>
                <DescriptionListTerm> {_("Autostart")} </DescriptionListTerm>
                <DescriptionListDescription id={`${idPrefix}-autostart`}> {storagePool.autostart ? _("yes") : _("no")} </DescriptionListDescription>
            </DescriptionListGroup>}

            <DescriptionListGroup>
                <DescriptionListTerm> {_("Type")} </DescriptionListTerm>
                <DescriptionListDescription id={`${idPrefix}-type`}> {storagePool.type} </DescriptionListDescription>
            </DescriptionListGroup>
        </DescriptionList>
    );
};
