# Zonemaster Engine

## Purpose

This repository holds one of the components of the Zonemaster product. For an
overview of the Zonemaster software, please see the
[Zonemaster main repository].

This Git repository contains the *Zonemaster Engine testing framework*,
and contains all code needed to perform the full suite of Zonemaster
tests.

## Prerequisites

For supported processor architectures, operating systems and Perl versions see
[Zonemaster/README.md].

## Installation

Installation instructions for the Engine is provided in the
[installation] document.

## Configuration

This repository does not need any specific configuration.

## Docker

Zonemaster-CLI is available on [Docker Hub], and can be conveniently downloaded
and run without any installation. See [USING] Zonemaster-CLI for how to run
Zonemaster-CLI on Docker.

To build your own Docker image, see the [Docker Image Creation] documentation.


## Documentation

There is full POD coverage of the Perl code. The documentation can be
read on the [CPAN site].

Documentation on Zonemaster-Engine is also found under the [docs] directory.


## Participation, Contact and Bug reporting

For participation, contact and bug reporting, please see
[Zonemaster/README.md](https://github.com/zonemaster/zonemaster/blob/master/README.md).


## License

This is free software under a 2-clause BSD license. The full text of the license can
be found in the [LICENSE](LICENSE) file included in this repository.


[CPAN site]:                                      https://metacpan.org/pod/Zonemaster::Engine
[Docker Hub]:                                     https://hub.docker.com/u/zonemaster
[Docker Image Creation]:                          https://github.com/zonemaster/zonemaster/blob/master/docs/internal/maintenance/ReleaseProcess-create-docker-image.md
[Docs]:                                           docs/
[Installation]:                                   https://github.com/zonemaster/zonemaster/blob/master/docs/public/installation/zonemaster-engine.md
[USING]:                                          https://github.com/zonemaster/zonemaster/blob/master/docs/public/using/cli.md
[Zonemaster main repository]:                     https://github.com/zonemaster/zonemaster
[Zonemaster/README.md]:                           https://github.com/zonemaster/zonemaster/blob/master/README.md



