# swift package

Subcommands to update and inspect your Swift package.

@Metadata {
    @PageImage(purpose: icon, source: command-icon)
}

## Overview

Overview of package manager commands here...

<!-- reference content for the CLI commands `swift package ...` -->

## Topics 

### Creating packages
- <doc:PackageInit>

### Updating and resolving dependencies
- <doc:PackageUpdate>
- <doc:PackageResolve>

### Editing packages
- <doc:PackageAddDependency>
- <doc:PackageAddProduct>
- <doc:PackageAddTarget>
- <doc:PackageAddTargetDependency>
- <doc:PackageAddSetting>
- <doc:PackageEdit>
- <doc:PackageUnedit>
- <doc:PackageMigrate>

### Using package manager plugins
- <doc:PackagePlugin>
- <doc:PackageDiagnoseAPIBreakingChange>
<!-- ref to swift-format -->
<!-- ref to swift-docc-plugin -->

### Inspecting packages
- <doc:PackageDescribe>
- <doc:PackageShowDependencies>
- <doc:PackageShowExecutables>
- <doc:PackageToolsVersion>
- <doc:PackageDumpPackage>
- <doc:PackageDumpSymbolGraph>

### Cleaning builds and caches
- <doc:PackageClean>
- <doc:PackageReset>
- <doc:PackagePurgeCache>

### Archiving packages
- <doc:PackageArchiveSource>
- <doc:PackageComputeChecksum>

### Integrating Package Manager into your shell
- <doc:PackageCompletionTool>

### Configuring Mirrors
- <doc:PackageConfigSetMirror>
- <doc:PackageConfigUnsetMirror>
- <doc:PackageConfigGetMirror>

### Experimental commands

- <doc:PackageExperimentalInstall>
- <doc:PackageExperimentalUninstall>

