/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GLOBALMANAGER_H
#define GLOBALMANAGER_H

#include <QDBusConnection>
#include <QDBusError>


#include "brightness.h"
#include "global-signal.h"

class GlobalManager
{
public:
    GlobalManager();
    GlobalManager(GlobalManager&)=delete;
    GlobalManager&operator=(const GlobalManager&)=delete;

public:
    ~GlobalManager();
    static GlobalManager *GlobalManagerNew();
    void start();
    void stop();
private:
    static GlobalManager *m_globalManager;
    Brightness *m_pBright = nullptr;
    GlobalSignal *m_pSignal = nullptr;
};

#endif // GLOBALMANAGER_H
