/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ParallelObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class ParallelConstructor
extends ObjectConstructor {
    PointObject P = null;
    PrimitiveLineObject L = null;

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!zirkelCanvas.Visual) {
            return;
        }
        if (this.L == null) {
            this.L = this.selectline(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
            if (this.L != null) {
                this.L.setSelected(true);
                zirkelCanvas.repaint();
            }
            this.showStatus(zirkelCanvas);
        } else {
            this.P = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
            if (this.P != null) {
                PrimitiveLineObject primitiveLineObject = this.create(zirkelCanvas.getConstruction(), this.L, this.P);
                zirkelCanvas.addObject(primitiveLineObject);
                primitiveLineObject.setDefaults();
                this.P = null;
                this.L = null;
                zirkelCanvas.clearSelected();
                this.showStatus(zirkelCanvas);
            }
        }
    }

    public boolean waitForLastPoint() {
        return this.L != null;
    }

    public void finishConstruction(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        this.P = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
        if (this.P != null) {
            PrimitiveLineObject primitiveLineObject = this.create(zirkelCanvas.getConstruction(), this.L, this.P);
            zirkelCanvas.addObject(primitiveLineObject);
            primitiveLineObject.setDefaults();
            zirkelCanvas.validate();
            zirkelCanvas.repaint();
            this.P = null;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        if (!bl && this.waitForLastPoint()) {
            if (zirkelCanvas.isPreview()) {
                zirkelCanvas.movePreview(mouseEvent);
            } else {
                zirkelCanvas.prepareForPreview(mouseEvent);
                this.finishConstruction(mouseEvent, zirkelCanvas);
            }
        }
        if (this.L == null) {
            zirkelCanvas.indicateLineObjects(mouseEvent.getX(), mouseEvent.getY());
        } else if (this.P == null) {
            zirkelCanvas.indicateCreatePoint(mouseEvent.getX(), mouseEvent.getY(), false);
        }
    }

    public PointObject select(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return zirkelCanvas.selectCreatePoint(n, n2);
    }

    public PrimitiveLineObject selectline(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return zirkelCanvas.selectLine(n, n2);
    }

    public PrimitiveLineObject create(Construction construction, PrimitiveLineObject primitiveLineObject, PointObject pointObject) {
        return new ParallelObject(construction, primitiveLineObject, pointObject);
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        if (zirkelCanvas.Visual) {
            this.P = null;
            this.L = null;
            this.showStatus(zirkelCanvas);
        } else {
            zirkelCanvas.setPrompt(this.getPrompt());
        }
    }

    public String getPrompt() {
        return Zirkel.name("prompt.parallel");
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.L == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.parallel.first", "Parallel: Choose a line!"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.parallel.second", "Parallel: Choose a Point!"));
        }
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        if (!this.testTree(xmlTree, "Parallel")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        if (!xmlTag.hasParam("point") || !xmlTag.hasParam("line")) {
            throw new ConstructionException("Parallel parameters missing!");
        }
        try {
            PointObject pointObject = (PointObject)construction.find(xmlTag.getValue("point"));
            PrimitiveLineObject primitiveLineObject = (PrimitiveLineObject)construction.find(xmlTag.getValue("line"));
            ParallelObject parallelObject = new ParallelObject(construction, primitiveLineObject, pointObject);
            this.setName(xmlTag, parallelObject);
            this.set(xmlTree, parallelObject);
            if (xmlTag.hasParam("partial")) {
                parallelObject.setPartial(true);
            }
            construction.add(parallelObject);
            this.setConditionals(xmlTree, construction, parallelObject);
        }
        catch (ConstructionException constructionException) {
            throw constructionException;
        }
        catch (Exception exception) {
            throw new ConstructionException("Parallel parameters illegal!");
        }
        return true;
    }

    public String getTag() {
        return "Parallel";
    }

    public void construct(Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
        if (n != 2) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        ConstructionObject constructionObject = construction.find(stringArray[0]);
        if (constructionObject == null) {
            throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[0]);
        }
        ConstructionObject constructionObject2 = construction.find(stringArray[1]);
        if (constructionObject2 == null) {
            throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[1]);
        }
        if (!(constructionObject instanceof PrimitiveLineObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[0]);
        }
        if (!(constructionObject2 instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[1]);
        }
        ParallelObject parallelObject = new ParallelObject(construction, (PrimitiveLineObject)constructionObject, (PointObject)constructionObject2);
        if (!string.equals("")) {
            parallelObject.setNameCheck(string);
        }
        construction.add(parallelObject);
        parallelObject.setDefaults();
    }
}

