// SPDX-License-Identifier: Apache-2.0
// Copyright (C) 2024-2025 Advanced Micro Devices, Inc. All rights reserved

#include "xdp/profile/writer/aie_debug/aie_debug_writer_metadata.h"

namespace xdp {

/*************************************************************************************
 * AIE1 Registers
 *************************************************************************************/
void AIE1WriterUsedRegisters::populateRegDataMap() {
   regDataMap["cm_cssd_trigger"].push_back(RegData("Trigger", "0", 0, 0x1));
   regDataMap["cm_combo_event_control"].push_back(RegData("combo2", "17:16", 16, 0x3));
   regDataMap["cm_combo_event_control"].push_back(RegData("combo0", "1:0", 0, 0x3));
   regDataMap["cm_combo_event_control"].push_back(RegData("combo1", "9:8", 8, 0x3));
   regDataMap["cm_combo_event_inputs"].push_back(RegData("eventB", "14:8", 8, 0x7F));
   regDataMap["cm_combo_event_inputs"].push_back(RegData("eventC", "22:16", 16, 0x7F));
   regDataMap["cm_combo_event_inputs"].push_back(RegData("eventD", "30:24", 24, 0x7F));
   regDataMap["cm_combo_event_inputs"].push_back(RegData("eventA", "6:0", 0, 0x7F));
   regDataMap["cm_core_cb0"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_cb1"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_cb2"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_cb3"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_cb4"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_cb5"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_cb6"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_cb7"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_ch0"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_ch1"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_ch2"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_ch3"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_ch4"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_ch5"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_ch6"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_ch7"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_cl0"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_cl1"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_cl2"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_cl3"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_cl4"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_cl5"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_cl6"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_cl7"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_cs0"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_cs1"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_cs2"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_cs3"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_cs4"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_cs5"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_cs6"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_cs7"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_control"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["cm_core_control"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["cm_core_fc"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_lc"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_le"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_lr"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_ls"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_m0"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_m1"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_m2"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_m3"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_m4"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_m5"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_m6"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_m7"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_mc0"].push_back(RegData("Carry", "0", 0, 0x1));
   regDataMap["cm_core_mc0"].push_back(RegData("SS0_tlast", "1", 1, 0x1));
   regDataMap["cm_core_mc0"].push_back(RegData("UPS_sat", "10", 10, 0x1));
   regDataMap["cm_core_mc0"].push_back(RegData("reserved", "15:11", 11, 0x1F));
   regDataMap["cm_core_mc0"].push_back(RegData("SS1_tlast", "2", 2, 0x1));
   regDataMap["cm_core_mc0"].push_back(RegData("Floating_Add_exceptions", "23:16", 16, 0xFF));
   regDataMap["cm_core_mc0"].push_back(RegData("WSS0_tlast", "3", 3, 0x1));
   regDataMap["cm_core_mc0"].push_back(RegData("Floating_Mul_exceptions", "31:24", 24, 0xFF));
   regDataMap["cm_core_mc0"].push_back(RegData("WSS1_tlast", "4", 4, 0x1));
   regDataMap["cm_core_mc0"].push_back(RegData("SS0_nb_sc", "5", 5, 0x1));
   regDataMap["cm_core_mc0"].push_back(RegData("SS1_nb_sc", "6", 6, 0x1));
   regDataMap["cm_core_mc0"].push_back(RegData("MS0_nb_sc", "7", 7, 0x1));
   regDataMap["cm_core_mc0"].push_back(RegData("MS1_nb_sc", "8", 8, 0x1));
   regDataMap["cm_core_mc0"].push_back(RegData("SRS_sat", "9", 9, 0x1));
   regDataMap["cm_core_mc1"].push_back(RegData("Fx2fl_Cnv_exceptions", "15:8", 8, 0xFF));
   regDataMap["cm_core_mc1"].push_back(RegData("Fl2Fx_Cnv_exceptions", "23:16", 16, 0xFF));
   regDataMap["cm_core_mc1"].push_back(RegData("reserved", "31:24", 24, 0xFF));
   regDataMap["cm_core_mc1"].push_back(RegData("Nlf_exceptions", "7:0", 0, 0xFF));
   regDataMap["cm_core_md0"].push_back(RegData("Saturation_Select", "0", 0, 0x1));
   regDataMap["cm_core_md0"].push_back(RegData("mdMS", "11:10", 10, 0x3));
   regDataMap["cm_core_md0"].push_back(RegData("reserved", "15:12", 12, 0xF));
   regDataMap["cm_core_md0"].push_back(RegData("Floating_Add_Mask", "23:16", 16, 0xFF));
   regDataMap["cm_core_md0"].push_back(RegData("Floating_Mul_Mask", "31:24", 24, 0xFF));
   regDataMap["cm_core_md0"].push_back(RegData("Round_Mode_Select", "3:1", 1, 0x7));
   regDataMap["cm_core_md0"].push_back(RegData("Radix_select", "6:4", 4, 0x7));
   regDataMap["cm_core_md0"].push_back(RegData("Symmetric_Saturation_Select", "7", 7, 0x1));
   regDataMap["cm_core_md0"].push_back(RegData("mdSS", "9:8", 8, 0x3));
   regDataMap["cm_core_md1"].push_back(RegData("Floating_Fixed_to_Float_Mask", "15:8", 8, 0xFF));
   regDataMap["cm_core_md1"].push_back(RegData("Floating_Float_to_Fixed_Mask", "23:16", 16, 0xFF));
   regDataMap["cm_core_md1"].push_back(RegData("reserved", "31:24", 24, 0xFF));
   regDataMap["cm_core_md1"].push_back(RegData("Floating_Non_Linear_Mask", "7:0", 0, 0xFF));
   regDataMap["cm_core_p0"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_p1"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_p2"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_p3"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_p4"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_p5"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_p6"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_p7"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_pc"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_r0"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r1"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r10"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r11"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r12"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r13"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r14"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r15"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r2"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r3"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r4"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r5"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r6"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r7"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r8"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r9"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_s0"].push_back(RegData("Register_Value", "7:0", 0, 0xFF));
   regDataMap["cm_core_s1"].push_back(RegData("Register_Value", "7:0", 0, 0xFF));
   regDataMap["cm_core_s2"].push_back(RegData("Register_Value", "7:0", 0, 0xFF));
   regDataMap["cm_core_s3"].push_back(RegData("Register_Value", "7:0", 0, 0xFF));
   regDataMap["cm_core_s4"].push_back(RegData("Register_Value", "7:0", 0, 0xFF));
   regDataMap["cm_core_s5"].push_back(RegData("Register_Value", "7:0", 0, 0xFF));
   regDataMap["cm_core_s6"].push_back(RegData("Register_Value", "7:0", 0, 0xFF));
   regDataMap["cm_core_s7"].push_back(RegData("Register_Value", "7:0", 0, 0xFF));
   regDataMap["cm_core_sp"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_status"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Stream_Stall_SS0", "10", 10, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Stream_Stall_SS1", "11", 11, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Stream_Stall_MS0", "12", 12, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Stream_Stall_MS1", "13", 13, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Cascade_Stall_SCD", "14", 14, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Cascade_Stall_MCD", "15", 15, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Debug_Halt", "16", 16, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("ECC_Error_Stall", "17", 17, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("ECC_Scrubbing_Stall", "18", 18, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Error_Halt", "19", 19, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Memory_Stall_S", "2", 2, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("reserved", "20", 20, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Memory_Stall_W", "3", 3, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Memory_Stall_N", "4", 4, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Memory_Stall_E", "5", 5, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Lock_Stall_S", "6", 6, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Lock_Stall_W", "7", 7, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Lock_Stall_N", "8", 8, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Lock_Stall_E", "9", 9, 0x1));
   regDataMap["cm_debug_control0"].push_back(RegData("Debug_Halt_Bit", "0", 0, 0x1));
   regDataMap["cm_debug_control0"].push_back(RegData("Single_Step_Count", "5:2", 2, 0xF));
   regDataMap["cm_debug_control1"].push_back(RegData("Debug_SingleStep_Core_Event", "14:8", 8, 0x7F));
   regDataMap["cm_debug_control1"].push_back(RegData("Debug_Halt_Core_Event0", "22:16", 16, 0x7F));
   regDataMap["cm_debug_control1"].push_back(RegData("Debug_Halt_Core_Event1", "30:24", 24, 0x7F));
   regDataMap["cm_debug_control1"].push_back(RegData("Debug_Resume_Core_Event", "6:0", 0, 0x7F));
   regDataMap["cm_debug_control2"].push_back(RegData("PC_Event_Halt", "0", 0, 0x1));
   regDataMap["cm_debug_control2"].push_back(RegData("Memory_Stall_Halt", "1", 1, 0x1));
   regDataMap["cm_debug_control2"].push_back(RegData("Lock_Stall_Halt", "2", 2, 0x1));
   regDataMap["cm_debug_control2"].push_back(RegData("Stream_Stall_Halt", "3", 3, 0x1));
   regDataMap["cm_debug_status"].push_back(RegData("Debug_halted", "0", 0, 0x1));
   regDataMap["cm_debug_status"].push_back(RegData("PC_Event_halted", "1", 1, 0x1));
   regDataMap["cm_debug_status"].push_back(RegData("Memory_Stall_Halted", "2", 2, 0x1));
   regDataMap["cm_debug_status"].push_back(RegData("Lock_Stall_Halted", "3", 3, 0x1));
   regDataMap["cm_debug_status"].push_back(RegData("Stream_stall_Halted", "4", 4, 0x1));
   regDataMap["cm_debug_status"].push_back(RegData("Debug_Event0_Halted", "5", 5, 0x1));
   regDataMap["cm_debug_status"].push_back(RegData("Debug_Event1_Halted", "6", 6, 0x1));
   regDataMap["cm_ecc_control"].push_back(RegData("Stall_Core_Control", "0", 0, 0x1));
   regDataMap["cm_ecc_control"].push_back(RegData("Unstall_Core", "1", 1, 0x1));
   regDataMap["cm_ecc_failing_address"].push_back(RegData("ECC_Error_Detection_Address", "13:0", 0, 0x3FFF));
   regDataMap["cm_ecc_failing_address"].push_back(RegData("Access_Type", "14", 14, 0x1));
   regDataMap["cm_ecc_failing_address"].push_back(RegData("Clear_failing_address", "15", 15, 0x1));
   regDataMap["cm_ecc_scrubbing_event"].push_back(RegData("Scrubbing_Event_number", "6:0", 0, 0x7F));
   regDataMap["cm_enable_events"].push_back(RegData("Disable_Event", "14:8", 8, 0x7F));
   regDataMap["cm_enable_events"].push_back(RegData("Disable_Event_occurred", "15", 15, 0x1));
   regDataMap["cm_enable_events"].push_back(RegData("Enable_Event", "6:0", 0, 0x7F));
   regDataMap["cm_enable_events"].push_back(RegData("Enable_Event_occurred", "7", 7, 0x1));
   regDataMap["cm_error_halt_control"].push_back(RegData("Error_Halt", "0", 0, 0x1));
   regDataMap["cm_error_halt_event"].push_back(RegData("Error_Halt_Core_Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast0"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast1"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast10"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast11"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast12"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast13"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast14"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast15"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast2"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast3"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast4"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast5"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast6"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast7"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast8"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast9"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast_block_east_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_east_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_east_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_north_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_north_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_north_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_south_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_south_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_south_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_west_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_west_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_west_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_generate"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Timer_Sync", "0", 0, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Timer_Value_Reached", "1", 1, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Perf_Cnt0", "2", 2, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Perf_Cnt1", "3", 3, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Perf_Cnt2", "4", 4, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Perf_Cnt3", "5", 5, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Combo_Event_0", "6", 6, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Combo_Event_1", "7", 7, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Combo_Event_2", "8", 8, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Combo_Event_3", "9", 9, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_0", "0", 0, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_1", "1", 1, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_10", "10", 10, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_11", "11", 11, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_12", "12", 12, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_13", "13", 13, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_14", "14", 14, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_15", "15", 15, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_2", "2", 2, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_3", "3", 3, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_4", "4", 4, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_5", "5", 5, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_6", "6", 6, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_7", "7", 7, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_8", "8", 8, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_9", "9", 9, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Event_0", "0", 0, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Event_1", "1", 1, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Cascade_Put", "10", 10, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Lock_Acquire_req", "11", 11, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Lock_Release_req", "12", 12, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Call", "2", 2, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Return", "3", 3, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Vector", "4", 4, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Load", "5", 5, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Store", "6", 6, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Stream_Get", "7", 7, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Stream_Put", "8", 8, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Cascade_Get", "9", 9, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("Memory_Stall", "0", 0, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("Stream_Stall", "1", 1, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("Cascade_Stall", "2", 2, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("Lock_Stall", "3", 3, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("Debug", "4", 4, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("Active", "5", 5, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("Disable", "6", 6, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("ECC_Scrubbing_Stall", "7", 7, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("ECC_Error_Stall", "8", 8, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("SRS_Saturate", "0", 0, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("UPS_Saturate", "1", 1, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("AXI_MM_Slave_Error", "10", 10, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("Instruction_Decompression_Error", "11", 11, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("DM_address_out_of_range", "12", 12, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("PM_ECC_Error_Scrub_Corrected", "13", 13, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("PM_ECC_Error_Scrub_2bit", "14", 14, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("PM_ECC_Error_1bit", "15", 15, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("PM_ECC_Error_2bit", "16", 16, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("PM_address_out_of_range", "17", 17, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("DM_access_to_Unavailable", "18", 18, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("Lock_Access_to_Unavailable", "19", 19, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("FP_Overflow", "2", 2, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("Instr_Warning", "20", 20, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("Instr_Error", "21", 21, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("FP_Underflow", "3", 3, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("FP_Invalid", "4", 4, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("FP_Div_by_Zero", "5", 5, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("TLAST_in_WSS_words_0_2", "6", 6, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("PM_Reg_Access_Failure", "7", 7, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("Stream_Pkt_Parity_Error", "8", 8, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("Control_Pkt_Error", "9", 9, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("SRS_Saturate", "0", 0, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("UPS_Saturate", "1", 1, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("AXI_MM_Slave_Error", "10", 10, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("Instruction_Decompression_Error", "11", 11, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("DM_address_out_of_range", "12", 12, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("PM_ECC_Error_Scrub_Corrected", "13", 13, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("PM_ECC_Error_Scrub_2bit", "14", 14, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("PM_ECC_Error_1bit", "15", 15, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("PM_ECC_Error_2bit", "16", 16, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("PM_address_out_of_range", "17", 17, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("DM_access_to_Unavailable", "18", 18, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("Lock_Access_to_Unavailable", "19", 19, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("FP_Overflow", "2", 2, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("Instr_Warning", "20", 20, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("Instr_Error", "21", 21, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("FP_Underflow", "3", 3, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("FP_Invalid", "4", 4, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("FP_Div_by_Zero", "5", 5, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("TLAST_in_WSS_words_0_2", "6", 6, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("PM_Reg_Access_Failure", "7", 7, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("Stream_Pkt_Parity_Error", "8", 8, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("Control_Pkt_Error", "9", 9, 0x1));
   regDataMap["cm_event_group_pc_enable"].push_back(RegData("PC_0", "0", 0, 0x1));
   regDataMap["cm_event_group_pc_enable"].push_back(RegData("PC_1", "1", 1, 0x1));
   regDataMap["cm_event_group_pc_enable"].push_back(RegData("PC_2", "2", 2, 0x1));
   regDataMap["cm_event_group_pc_enable"].push_back(RegData("PC_3", "3", 3, 0x1));
   regDataMap["cm_event_group_pc_enable"].push_back(RegData("PC_Range_0_1", "4", 4, 0x1));
   regDataMap["cm_event_group_pc_enable"].push_back(RegData("PC_Range_2_3", "5", 5, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_0", "0", 0, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Running_0", "1", 1, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_2", "10", 10, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_2", "11", 11, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_3", "12", 12, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Running_3", "13", 13, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_3", "14", 14, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_3", "15", 15, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_4", "16", 16, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Running_4", "17", 17, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_4", "18", 18, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_4", "19", 19, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_0", "2", 2, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_5", "20", 20, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Running_5", "21", 21, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_5", "22", 22, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_5", "23", 23, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_6", "24", 24, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Running_6", "25", 25, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_6", "26", 26, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_6", "27", 27, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_7", "28", 28, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Running_7", "29", 29, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_0", "3", 3, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_7", "30", 30, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_7", "31", 31, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_1", "4", 4, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Running_1", "5", 5, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_1", "6", 6, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_1", "7", 7, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_2", "8", 8, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Running_2", "9", 9, 0x1));
   regDataMap["cm_event_group_user_event_enable"].push_back(RegData("User_Event_0", "0", 0, 0x1));
   regDataMap["cm_event_group_user_event_enable"].push_back(RegData("User_Event_1", "1", 1, 0x1));
   regDataMap["cm_event_group_user_event_enable"].push_back(RegData("User_Event_2", "2", 2, 0x1));
   regDataMap["cm_event_group_user_event_enable"].push_back(RegData("User_Event_3", "3", 3, 0x1));
   regDataMap["cm_event_status0"].push_back(RegData("Event_31_0_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_event_status1"].push_back(RegData("Event_63_32_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_event_status2"].push_back(RegData("Event_95_64_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_event_status3"].push_back(RegData("Event_127_96_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_pc_event0"].push_back(RegData("PC_Address", "13:0", 0, 0x3FFF));
   regDataMap["cm_pc_event0"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["cm_pc_event1"].push_back(RegData("PC_Address", "13:0", 0, 0x3FFF));
   regDataMap["cm_pc_event1"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["cm_pc_event2"].push_back(RegData("PC_Address", "13:0", 0, 0x3FFF));
   regDataMap["cm_pc_event2"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["cm_pc_event3"].push_back(RegData("PC_Address", "13:0", 0, 0x3FFF));
   regDataMap["cm_pc_event3"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["cm_performance_counter0"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_performance_counter0_event_value"].push_back(RegData("Counter_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_performance_counter1"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_performance_counter1_event_value"].push_back(RegData("Counter_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_performance_counter2"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_performance_counter2_event_value"].push_back(RegData("Counter_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_performance_counter3"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_performance_counter3_event_value"].push_back(RegData("Counter_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_performance_ctrl0"].push_back(RegData("Cnt0_Stop_Event", "14:8", 8, 0x7F));
   regDataMap["cm_performance_ctrl0"].push_back(RegData("Cnt1_Start_Event", "22:16", 16, 0x7F));
   regDataMap["cm_performance_ctrl0"].push_back(RegData("Cnt1_Stop_Event", "30:24", 24, 0x7F));
   regDataMap["cm_performance_ctrl0"].push_back(RegData("Cnt0_Start_Event", "6:0", 0, 0x7F));
   regDataMap["cm_performance_ctrl1"].push_back(RegData("Cnt2_Stop_Event", "14:8", 8, 0x7F));
   regDataMap["cm_performance_ctrl1"].push_back(RegData("Cnt3_Start_Event", "22:16", 16, 0x7F));
   regDataMap["cm_performance_ctrl1"].push_back(RegData("Cnt3_Stop_Event", "30:24", 24, 0x7F));
   regDataMap["cm_performance_ctrl1"].push_back(RegData("Cnt2_Start_Event", "6:0", 0, 0x7F));
   regDataMap["cm_performance_ctrl2"].push_back(RegData("Cnt1_Reset_Event", "14:8", 8, 0x7F));
   regDataMap["cm_performance_ctrl2"].push_back(RegData("Cnt2_Reset_Event", "22:16", 16, 0x7F));
   regDataMap["cm_performance_ctrl2"].push_back(RegData("Cnt3_Reset_Event", "30:24", 24, 0x7F));
   regDataMap["cm_performance_ctrl2"].push_back(RegData("Cnt0_Reset_Event", "6:0", 0, 0x7F));
   regDataMap["cm_reserved0"].push_back(RegData("reserved", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_reserved1"].push_back(RegData("reserved", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_reserved2"].push_back(RegData("reserved", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_reserved3"].push_back(RegData("reserved", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_reset_event"].push_back(RegData("Reset_Event", "6:0", 0, 0x7F));
   regDataMap["cm_spare_reg"].push_back(RegData("Spare_Reg", "15:0", 0, 0xFFFF));
   regDataMap["cm_stream_switch_event_port_selection_0"].push_back(RegData("Port_1_ID", "12:8", 8, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_0"].push_back(RegData("Port_1_Master_Slave", "13", 13, 0x1));
   regDataMap["cm_stream_switch_event_port_selection_0"].push_back(RegData("Port_2_ID", "20:16", 16, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_0"].push_back(RegData("Port_2_Master_Slave", "21", 21, 0x1));
   regDataMap["cm_stream_switch_event_port_selection_0"].push_back(RegData("Port_3_ID", "28:24", 24, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_0"].push_back(RegData("Port_3_Master_Slave", "29", 29, 0x1));
   regDataMap["cm_stream_switch_event_port_selection_0"].push_back(RegData("Port_0_ID", "4:0", 0, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_0"].push_back(RegData("Port_0_Master_Slave", "5", 5, 0x1));
   regDataMap["cm_stream_switch_event_port_selection_1"].push_back(RegData("Port_5_ID", "12:8", 8, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_1"].push_back(RegData("Port_5_Master_Slave", "13", 13, 0x1));
   regDataMap["cm_stream_switch_event_port_selection_1"].push_back(RegData("Port_6_ID", "20:16", 16, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_1"].push_back(RegData("Port_6_Master_Slave", "21", 21, 0x1));
   regDataMap["cm_stream_switch_event_port_selection_1"].push_back(RegData("Port_7_ID", "28:24", 24, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_1"].push_back(RegData("Port_7_Master_Slave", "29", 29, 0x1));
   regDataMap["cm_stream_switch_event_port_selection_1"].push_back(RegData("Port_4_ID", "4:0", 0, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_1"].push_back(RegData("Port_4_Master_Slave", "5", 5, 0x1));
   regDataMap["cm_stream_switch_master_config_dma0"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_dma0"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_dma0"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_dma0"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_dma1"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_dma1"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_dma1"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_dma1"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_east0"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_east0"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_east0"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_east0"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_east1"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_east1"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_east1"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_east1"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_east2"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_east2"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_east2"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_east2"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_east3"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_east3"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_east3"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_east3"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_fifo0"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_fifo0"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_fifo0"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_fifo0"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_fifo1"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_fifo1"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_fifo1"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_fifo1"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_me_core0"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_me_core0"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_me_core0"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_me_core0"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_me_core1"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_me_core1"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_me_core1"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_me_core1"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_north0"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_north0"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_north0"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_north0"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_north1"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_north1"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_north1"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_north1"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_north2"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_north2"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_north2"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_north2"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_north3"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_north3"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_north3"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_north3"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_north4"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_north4"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_north4"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_north4"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_north5"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_north5"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_north5"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_north5"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_south0"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_south0"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_south0"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_south0"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_south1"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_south1"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_south1"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_south1"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_south2"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_south2"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_south2"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_south2"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_south3"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_south3"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_south3"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_south3"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_tile_ctrl"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_tile_ctrl"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_tile_ctrl"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_tile_ctrl"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_west0"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_west0"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_west0"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_west0"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_west1"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_west1"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_west1"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_west1"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_west2"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_west2"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_west2"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_west2"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_stream_switch_master_config_west3"].push_back(RegData("Packet_Enable", "30", 30, 0x1));
   regDataMap["cm_stream_switch_master_config_west3"].push_back(RegData("Master_Enable", "31", 31, 0x1));
   regDataMap["cm_stream_switch_master_config_west3"].push_back(RegData("Configuration", "6:0", 0, 0x7F));
   regDataMap["cm_stream_switch_master_config_west3"].push_back(RegData("Drop_Header", "7", 7, 0x1));
   regDataMap["cm_tile_clock_control"].push_back(RegData("Clock_Buffer_Enable", "0", 0, 0x1));
   regDataMap["cm_tile_clock_control"].push_back(RegData("Next_Tile_Clock_Enable", "1", 1, 0x1));
   regDataMap["cm_tile_control"].push_back(RegData("Isolate_From_South", "0", 0, 0x1));
   regDataMap["cm_tile_control"].push_back(RegData("Isolate_From_West", "1", 1, 0x1));
   regDataMap["cm_tile_control"].push_back(RegData("Isolate_From_North", "2", 2, 0x1));
   regDataMap["cm_tile_control"].push_back(RegData("Isolate_From_East", "3", 3, 0x1));
   regDataMap["cm_tile_control_packet_handler_status"].push_back(RegData("First_Header_Parity_Error", "0", 0, 0x1));
   regDataMap["cm_tile_control_packet_handler_status"].push_back(RegData("Second_Header_Parity_Error", "1", 1, 0x1));
   regDataMap["cm_tile_control_packet_handler_status"].push_back(RegData("SLVERR_On_Access", "2", 2, 0x1));
   regDataMap["cm_tile_control_packet_handler_status"].push_back(RegData("Tlast_Error", "3", 3, 0x1));
   regDataMap["cm_timer_control"].push_back(RegData("Reset_Event", "14:8", 8, 0x7F));
   regDataMap["cm_timer_control"].push_back(RegData("Reset", "31", 31, 0x1));
   regDataMap["cm_timer_high"].push_back(RegData("TimerHigh", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_timer_low"].push_back(RegData("TimerLow", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_timer_trig_event_high_value"].push_back(RegData("TimerTrigHigh", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_timer_trig_event_low_value"].push_back(RegData("TimerTrigLow", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_trace_control0"].push_back(RegData("Mode", "1:0", 0, 0x3));
   regDataMap["cm_trace_control0"].push_back(RegData("Trace_Start_Event", "22:16", 16, 0x7F));
   regDataMap["cm_trace_control0"].push_back(RegData("Trace_Stop_Event", "30:24", 24, 0x7F));
   regDataMap["cm_trace_control1"].push_back(RegData("Packet_Type", "14:12", 12, 0x7));
   regDataMap["cm_trace_control1"].push_back(RegData("ID", "4:0", 0, 0x1F));
   regDataMap["cm_trace_event0"].push_back(RegData("Trace_Event1", "14:8", 8, 0x7F));
   regDataMap["cm_trace_event0"].push_back(RegData("Trace_Event2", "22:16", 16, 0x7F));
   regDataMap["cm_trace_event0"].push_back(RegData("Trace_Event3", "30:24", 24, 0x7F));
   regDataMap["cm_trace_event0"].push_back(RegData("Trace_Event0", "6:0", 0, 0x7F));
   regDataMap["cm_trace_event1"].push_back(RegData("Trace_Event5", "14:8", 8, 0x7F));
   regDataMap["cm_trace_event1"].push_back(RegData("Trace_Event6", "22:16", 16, 0x7F));
   regDataMap["cm_trace_event1"].push_back(RegData("Trace_Event7", "30:24", 24, 0x7F));
   regDataMap["cm_trace_event1"].push_back(RegData("Trace_Event4", "6:0", 0, 0x7F));
   regDataMap["cm_trace_status"].push_back(RegData("Mode", "2:0", 0, 0x7));
   regDataMap["cm_trace_status"].push_back(RegData("State", "9:8", 8, 0x3));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock0_State", "0", 0, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock0_Value", "1", 1, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock5_State", "10", 10, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock5_Value", "11", 11, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock6_State", "12", 12, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock6_Value", "13", 13, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock7_State", "14", 14, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock7_Value", "15", 15, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock8_State", "16", 16, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock8_Value", "17", 17, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock9_State", "18", 18, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock9_Value", "19", 19, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock1_State", "2", 2, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock10_State", "20", 20, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock10_Value", "21", 21, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock11_State", "22", 22, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock11_Value", "23", 23, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock12_State", "24", 24, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock12_Value", "25", 25, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock13_State", "26", 26, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock13_Value", "27", 27, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock14_State", "28", 28, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock14_Value", "29", 29, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock1_Value", "3", 3, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock15_State", "30", 30, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock15_Value", "31", 31, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock2_State", "4", 4, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock2_Value", "5", 5, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock3_State", "6", 6, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock3_Value", "7", 7, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock4_State", "8", 8, 0x1));
   regDataMap["mm_all_lock_state_value"].push_back(RegData("Lock4_Value", "9", 9, 0x1));
   regDataMap["mm_checkbit_error_generation"].push_back(RegData("Lane0", "0", 0, 0x1));
   regDataMap["mm_checkbit_error_generation"].push_back(RegData("Lane1", "1", 1, 0x1));
   regDataMap["mm_checkbit_error_generation"].push_back(RegData("Lane2", "2", 2, 0x1));
   regDataMap["mm_checkbit_error_generation"].push_back(RegData("Lane3", "3", 3, 0x1));
   regDataMap["mm_combo_event_control"].push_back(RegData("combo2", "17:16", 16, 0x3));
   regDataMap["mm_combo_event_control"].push_back(RegData("combo0", "1:0", 0, 0x3));
   regDataMap["mm_combo_event_control"].push_back(RegData("combo1", "9:8", 8, 0x3));
   regDataMap["mm_combo_event_inputs"].push_back(RegData("eventB", "14:8", 8, 0x7F));
   regDataMap["mm_combo_event_inputs"].push_back(RegData("eventC", "22:16", 16, 0x7F));
   regDataMap["mm_combo_event_inputs"].push_back(RegData("eventD", "30:24", 24, 0x7F));
   regDataMap["mm_combo_event_inputs"].push_back(RegData("eventA", "6:0", 0, 0x7F));
   regDataMap["mm_dma_fifo_counter"].push_back(RegData("Counter0", "12:0", 0, 0x1FFF));
   regDataMap["mm_dma_fifo_counter"].push_back(RegData("Counter1", "28:16", 16, 0x1FFF));
   regDataMap["mm_dma_mm2s_0_ctrl"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["mm_dma_mm2s_0_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mm_dma_mm2s_0_start_queue"].push_back(RegData("Start_BD", "3:0", 0, 0xF));
   regDataMap["mm_dma_mm2s_1_ctrl"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["mm_dma_mm2s_1_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mm_dma_mm2s_1_start_queue"].push_back(RegData("Start_BD", "3:0", 0, 0xF));
   regDataMap["mm_dma_mm2s_status"].push_back(RegData("Start_Queue_Size_1", "11:9", 9, 0x7));
   regDataMap["mm_dma_mm2s_status"].push_back(RegData("Cur_BD_0", "19:16", 16, 0xF));
   regDataMap["mm_dma_mm2s_status"].push_back(RegData("Stat0", "1:0", 0, 0x3));
   regDataMap["mm_dma_mm2s_status"].push_back(RegData("Cur_BD_1", "23:20", 20, 0xF));
   regDataMap["mm_dma_mm2s_status"].push_back(RegData("Start_Queue_Overflow_0", "28", 28, 0x1));
   regDataMap["mm_dma_mm2s_status"].push_back(RegData("Start_Queue_Overflow_1", "29", 29, 0x1));
   regDataMap["mm_dma_mm2s_status"].push_back(RegData("Stat1", "3:2", 2, 0x3));
   regDataMap["mm_dma_mm2s_status"].push_back(RegData("Lock_stalled0", "4", 4, 0x1));
   regDataMap["mm_dma_mm2s_status"].push_back(RegData("Lock_stalled1", "5", 5, 0x1));
   regDataMap["mm_dma_mm2s_status"].push_back(RegData("Start_Queue_Size_0", "8:6", 6, 0x7));
   regDataMap["mm_dma_s2mm_0_ctrl"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["mm_dma_s2mm_0_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mm_dma_s2mm_0_start_queue"].push_back(RegData("Start_BD", "3:0", 0, 0xF));
   regDataMap["mm_dma_s2mm_1_ctrl"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["mm_dma_s2mm_1_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mm_dma_s2mm_1_start_queue"].push_back(RegData("Start_BD", "3:0", 0, 0xF));
   regDataMap["mm_dma_s2mm_status"].push_back(RegData("Start_Queue_Size_1", "11:9", 9, 0x7));
   regDataMap["mm_dma_s2mm_status"].push_back(RegData("Cur_BD_0", "19:16", 16, 0xF));
   regDataMap["mm_dma_s2mm_status"].push_back(RegData("Stat0", "1:0", 0, 0x3));
   regDataMap["mm_dma_s2mm_status"].push_back(RegData("Cur_BD_1", "23:20", 20, 0xF));
   regDataMap["mm_dma_s2mm_status"].push_back(RegData("Start_Queue_Overflow_0", "28", 28, 0x1));
   regDataMap["mm_dma_s2mm_status"].push_back(RegData("Start_Queue_Overflow_1", "29", 29, 0x1));
   regDataMap["mm_dma_s2mm_status"].push_back(RegData("Stat1", "3:2", 2, 0x3));
   regDataMap["mm_dma_s2mm_status"].push_back(RegData("Lock_stalled0", "4", 4, 0x1));
   regDataMap["mm_dma_s2mm_status"].push_back(RegData("Lock_stalled1", "5", 5, 0x1));
   regDataMap["mm_dma_s2mm_status"].push_back(RegData("Start_Queue_Size_0", "8:6", 6, 0x7));
   regDataMap["mm_ecc_failing_address"].push_back(RegData("ECC_Error_Detection_Address", "13:0", 0, 0x3FFF));
   regDataMap["mm_ecc_failing_address"].push_back(RegData("Valid", "15", 15, 0x1));
   regDataMap["mm_ecc_scrubbing_event"].push_back(RegData("Scrubbing_Event_number", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast0"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast1"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast10"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast11"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast12"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast13"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast14"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast15"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast2"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast3"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast4"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast5"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast6"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast7"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast8"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast9"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast_block_east_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_east_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_east_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_north_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_north_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_north_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_south_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_south_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_south_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_west_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_west_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_west_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_generate"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Timer_Sync", "0", 0, 0x1));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Timer_Value_Reached", "1", 1, 0x1));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Perf_Cnt0_Event", "2", 2, 0x1));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Perf_Cnt1_Event", "3", 3, 0x1));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Combo_Event_0", "4", 4, 0x1));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Combo_Event_1", "5", 5, 0x1));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Combo_Event_2", "6", 6, 0x1));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Combo_Event_3", "7", 7, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_0", "0", 0, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_1", "1", 1, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_10", "10", 10, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_11", "11", 11, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_12", "12", 12, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_13", "13", 13, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_14", "14", 14, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_15", "15", 15, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_2", "2", 2, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_3", "3", 3, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_4", "4", 4, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_5", "5", 5, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_6", "6", 6, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_7", "7", 7, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_8", "8", 8, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_9", "9", 9, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_0_start_BD", "0", 0, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_1_start_BD", "1", 1, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_0_go_to_idle", "10", 10, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_1_go_to_idle", "11", 11, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_0_stalled_lock_acquire", "12", 12, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_1_stalled_lock_acquire", "13", 13, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_0_stalled_lock_acquire", "14", 14, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_1_stalled_lock_acquire", "15", 15, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_0_memory_conflict", "16", 16, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_1_memory_conflict", "17", 17, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_0_memory_conflict", "18", 18, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_1_memory_conflict", "19", 19, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_0_start_BD", "2", 2, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_1_start_BD", "3", 3, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_0_finished_BD", "4", 4, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_1_finished_BD", "5", 5, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_0_finished_BD", "6", 6, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_1_finished_BD", "7", 7, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_0_go_to_idle", "8", 8, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_1_go_to_idle", "9", 9, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_ECC_Error_Scrub_Corrected", "0", 0, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_ECC_Error_Scrub_2bit", "1", 1, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DMA_S2MM_0_Error", "10", 10, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DMA_S2MM_1_Error", "11", 11, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DMA_MM2S_0_Error", "12", 12, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DMA_MM2S_1_Error", "13", 13, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_ECC_Error_1bit", "2", 2, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_ECC_Error_2bit", "3", 3, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_Parity_Error_Bank_2", "4", 4, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_Parity_Error_Bank_3", "5", 5, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_Parity_Error_Bank_4", "6", 6, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_Parity_Error_Bank_5", "7", 7, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_Parity_Error_Bank_6", "8", 8, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_Parity_Error_Bank_7", "9", 9, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_0_Acquired", "0", 0, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_0_Release", "1", 1, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_5_Acquired", "10", 10, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_5_Release", "11", 11, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_6_Acquired", "12", 12, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_6_Release", "13", 13, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_7_Acquired", "14", 14, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_7_Release", "15", 15, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_8_Acquired", "16", 16, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_8_Release", "17", 17, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_9_Acquired", "18", 18, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_9_Release", "19", 19, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_1_Acquired", "2", 2, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_10_Acquired", "20", 20, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_10_Release", "21", 21, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_11_Acquired", "22", 22, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_11_Release", "23", 23, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_12_Acquired", "24", 24, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_12_Release", "25", 25, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_13_Acquired", "26", 26, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_13_Release", "27", 27, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_14_Acquired", "28", 28, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_14_Release", "29", 29, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_1_Release", "3", 3, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_15_Acquired", "30", 30, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_15_Release", "31", 31, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_2_Acquired", "4", 4, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_2_Release", "5", 5, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_3_Acquired", "6", 6, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_3_Release", "7", 7, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_4_Acquired", "8", 8, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_4_Release", "9", 9, 0x1));
   regDataMap["mm_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_0", "0", 0, 0x1));
   regDataMap["mm_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_1", "1", 1, 0x1));
   regDataMap["mm_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_2", "2", 2, 0x1));
   regDataMap["mm_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_3", "3", 3, 0x1));
   regDataMap["mm_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_4", "4", 4, 0x1));
   regDataMap["mm_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_5", "5", 5, 0x1));
   regDataMap["mm_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_6", "6", 6, 0x1));
   regDataMap["mm_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_7", "7", 7, 0x1));
   regDataMap["mm_event_group_user_event_enable"].push_back(RegData("User_Event_0", "0", 0, 0x1));
   regDataMap["mm_event_group_user_event_enable"].push_back(RegData("User_Event_1", "1", 1, 0x1));
   regDataMap["mm_event_group_user_event_enable"].push_back(RegData("User_Event_2", "2", 2, 0x1));
   regDataMap["mm_event_group_user_event_enable"].push_back(RegData("User_Event_3", "3", 3, 0x1));
   regDataMap["mm_event_group_watchpoint_enable"].push_back(RegData("Watchpoint_0", "0", 0, 0x1));
   regDataMap["mm_event_group_watchpoint_enable"].push_back(RegData("Watchpoint_1", "1", 1, 0x1));
   regDataMap["mm_event_status0"].push_back(RegData("Event_31_0_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_event_status1"].push_back(RegData("Event_63_32_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_event_status2"].push_back(RegData("Event_95_64_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_event_status3"].push_back(RegData("Event_127_96_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_lock0_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock0_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock0_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock0_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock0_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock0_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock10_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock10_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock10_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock10_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock10_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock10_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock11_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock11_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock11_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock11_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock11_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock11_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock12_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock12_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock12_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock12_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock12_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock12_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock13_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock13_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock13_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock13_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock13_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock13_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock14_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock14_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock14_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock14_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock14_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock14_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock15_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock15_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock15_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock15_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock15_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock15_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock1_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock1_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock1_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock1_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock1_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock1_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock2_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock2_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock2_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock2_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock2_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock2_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock3_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock3_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock3_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock3_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock3_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock3_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock4_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock4_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock4_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock4_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock4_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock4_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock5_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock5_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock5_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock5_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock5_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock5_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock6_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock6_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock6_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock6_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock6_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock6_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock7_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock7_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock7_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock7_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock7_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock7_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock8_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock8_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock8_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock8_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock8_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock8_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock9_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock9_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock9_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["mm_lock9_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock9_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock9_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["mm_lock_event_value_control_0"].push_back(RegData("Lock_2_Release", "11:10", 10, 0x3));
   regDataMap["mm_lock_event_value_control_0"].push_back(RegData("Lock_3_Acquired", "13:12", 12, 0x3));
   regDataMap["mm_lock_event_value_control_0"].push_back(RegData("Lock_3_Release", "15:14", 14, 0x3));
   regDataMap["mm_lock_event_value_control_0"].push_back(RegData("Lock_4_Acquired", "17:16", 16, 0x3));
   regDataMap["mm_lock_event_value_control_0"].push_back(RegData("Lock_4_Release", "19:18", 18, 0x3));
   regDataMap["mm_lock_event_value_control_0"].push_back(RegData("Lock_0_Acquired", "1:0", 0, 0x3));
   regDataMap["mm_lock_event_value_control_0"].push_back(RegData("Lock_5_Acquired", "21:20", 20, 0x3));
   regDataMap["mm_lock_event_value_control_0"].push_back(RegData("Lock_5_Release", "23:22", 22, 0x3));
   regDataMap["mm_lock_event_value_control_0"].push_back(RegData("Lock_6_Acquired", "25:24", 24, 0x3));
   regDataMap["mm_lock_event_value_control_0"].push_back(RegData("Lock_6_Release", "27:26", 26, 0x3));
   regDataMap["mm_lock_event_value_control_0"].push_back(RegData("Lock_7_Acquired", "29:28", 28, 0x3));
   regDataMap["mm_lock_event_value_control_0"].push_back(RegData("Lock_7_Release", "31:30", 30, 0x3));
   regDataMap["mm_lock_event_value_control_0"].push_back(RegData("Lock_0_Release", "3:2", 2, 0x3));
   regDataMap["mm_lock_event_value_control_0"].push_back(RegData("Lock_1_Acquired", "5:4", 4, 0x3));
   regDataMap["mm_lock_event_value_control_0"].push_back(RegData("Lock_1_Release", "7:6", 6, 0x3));
   regDataMap["mm_lock_event_value_control_0"].push_back(RegData("Lock_2_Acquired", "9:8", 8, 0x3));
   regDataMap["mm_lock_event_value_control_1"].push_back(RegData("Lock_10_Release", "11:10", 10, 0x3));
   regDataMap["mm_lock_event_value_control_1"].push_back(RegData("Lock_11_Acquired", "13:12", 12, 0x3));
   regDataMap["mm_lock_event_value_control_1"].push_back(RegData("Lock_11_Release", "15:14", 14, 0x3));
   regDataMap["mm_lock_event_value_control_1"].push_back(RegData("Lock_12_Acquired", "17:16", 16, 0x3));
   regDataMap["mm_lock_event_value_control_1"].push_back(RegData("Lock_12_Release", "19:18", 18, 0x3));
   regDataMap["mm_lock_event_value_control_1"].push_back(RegData("Lock_8_Acquired", "1:0", 0, 0x3));
   regDataMap["mm_lock_event_value_control_1"].push_back(RegData("Lock_13_Acquired", "21:20", 20, 0x3));
   regDataMap["mm_lock_event_value_control_1"].push_back(RegData("Lock_13_Release", "23:22", 22, 0x3));
   regDataMap["mm_lock_event_value_control_1"].push_back(RegData("Lock_14_Acquired", "25:24", 24, 0x3));
   regDataMap["mm_lock_event_value_control_1"].push_back(RegData("Lock_14_Release", "27:26", 26, 0x3));
   regDataMap["mm_lock_event_value_control_1"].push_back(RegData("Lock_15_Acquired", "29:28", 28, 0x3));
   regDataMap["mm_lock_event_value_control_1"].push_back(RegData("Lock_15_Release", "31:30", 30, 0x3));
   regDataMap["mm_lock_event_value_control_1"].push_back(RegData("Lock_8_Release", "3:2", 2, 0x3));
   regDataMap["mm_lock_event_value_control_1"].push_back(RegData("Lock_9_Acquired", "5:4", 4, 0x3));
   regDataMap["mm_lock_event_value_control_1"].push_back(RegData("Lock_9_Release", "7:6", 6, 0x3));
   regDataMap["mm_lock_event_value_control_1"].push_back(RegData("Lock_10_Acquired", "9:8", 8, 0x3));
   regDataMap["mm_parity_failing_address"].push_back(RegData("Parity_Error_Detection_Address", "14:0", 0, 0x7FFF));
   regDataMap["mm_parity_failing_address"].push_back(RegData("Valid", "15", 15, 0x1));
   regDataMap["mm_performance_control0"].push_back(RegData("Cnt0_Stop_Event", "14:8", 8, 0x7F));
   regDataMap["mm_performance_control0"].push_back(RegData("Cnt1_Start_Event", "22:16", 16, 0x7F));
   regDataMap["mm_performance_control0"].push_back(RegData("Cnt1_Stop_Event", "30:24", 24, 0x7F));
   regDataMap["mm_performance_control0"].push_back(RegData("Cnt0_Start_Event", "6:0", 0, 0x7F));
   regDataMap["mm_performance_control1"].push_back(RegData("Cnt1_Reset_Event", "14:8", 8, 0x7F));
   regDataMap["mm_performance_control1"].push_back(RegData("Cnt0_Reset_Event", "6:0", 0, 0x7F));
   regDataMap["mm_performance_counter0"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_performance_counter0_event_value"].push_back(RegData("Counter0_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_performance_counter1"].push_back(RegData("Counter1_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_performance_counter1_event_value"].push_back(RegData("Counter1_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_reserved0"].push_back(RegData("reserved", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_reserved1"].push_back(RegData("reserved", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_reserved2"].push_back(RegData("reserved", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_reserved3"].push_back(RegData("reserved", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_reset_control"].push_back(RegData("DMA_reset", "0", 0, 0x1));
   regDataMap["mm_spare_reg"].push_back(RegData("Spare_Reg", "15:0", 0, 0xFFFF));
   regDataMap["mm_timer_control"].push_back(RegData("Reset_Event", "14:8", 8, 0x7F));
   regDataMap["mm_timer_control"].push_back(RegData("Reset", "31", 31, 0x1));
   regDataMap["mm_timer_high"].push_back(RegData("TimerHigh", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_timer_low"].push_back(RegData("TimerLow", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_timer_trig_event_high_value"].push_back(RegData("TimerTrigHigh", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_timer_trig_event_low_value"].push_back(RegData("TimerTrigLow", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_trace_control0"].push_back(RegData("Trace_Start_Event", "22:16", 16, 0x7F));
   regDataMap["mm_trace_control0"].push_back(RegData("Trace_Stop_Event", "30:24", 24, 0x7F));
   regDataMap["mm_trace_control1"].push_back(RegData("Packet_Type", "14:12", 12, 0x7));
   regDataMap["mm_trace_control1"].push_back(RegData("ID", "4:0", 0, 0x1F));
   regDataMap["mm_trace_event0"].push_back(RegData("Trace_Event1", "14:8", 8, 0x7F));
   regDataMap["mm_trace_event0"].push_back(RegData("Trace_Event2", "22:16", 16, 0x7F));
   regDataMap["mm_trace_event0"].push_back(RegData("Trace_Event3", "30:24", 24, 0x7F));
   regDataMap["mm_trace_event0"].push_back(RegData("Trace_Event0", "6:0", 0, 0x7F));
   regDataMap["mm_trace_event1"].push_back(RegData("Trace_Event5", "14:8", 8, 0x7F));
   regDataMap["mm_trace_event1"].push_back(RegData("Trace_Event6", "22:16", 16, 0x7F));
   regDataMap["mm_trace_event1"].push_back(RegData("Trace_Event7", "30:24", 24, 0x7F));
   regDataMap["mm_trace_event1"].push_back(RegData("Trace_Event4", "6:0", 0, 0x7F));
   regDataMap["mm_trace_status"].push_back(RegData("Mode", "2:0", 0, 0x7));
   regDataMap["mm_trace_status"].push_back(RegData("State", "9:8", 8, 0x3));
   regDataMap["mm_watchpoint0"].push_back(RegData("Address", "14:4", 4, 0x7FF));
   regDataMap["mm_watchpoint0"].push_back(RegData("WriteStrobes", "23:20", 20, 0xF));
   regDataMap["mm_watchpoint0"].push_back(RegData("South_Access", "24", 24, 0x1));
   regDataMap["mm_watchpoint0"].push_back(RegData("West_Access", "25", 25, 0x1));
   regDataMap["mm_watchpoint0"].push_back(RegData("North_Access", "26", 26, 0x1));
   regDataMap["mm_watchpoint0"].push_back(RegData("East_Access", "27", 27, 0x1));
   regDataMap["mm_watchpoint0"].push_back(RegData("DMA_Access", "28", 28, 0x1));
   regDataMap["mm_watchpoint0"].push_back(RegData("AXI_Access", "29", 29, 0x1));
   regDataMap["mm_watchpoint0"].push_back(RegData("Write_Access", "30", 30, 0x1));
   regDataMap["mm_watchpoint0"].push_back(RegData("Read_Access", "31", 31, 0x1));
   regDataMap["mm_watchpoint1"].push_back(RegData("Address", "14:4", 4, 0x7FF));
   regDataMap["mm_watchpoint1"].push_back(RegData("WriteStrobes", "23:20", 20, 0xF));
   regDataMap["mm_watchpoint1"].push_back(RegData("South_Access", "24", 24, 0x1));
   regDataMap["mm_watchpoint1"].push_back(RegData("West_Access", "25", 25, 0x1));
   regDataMap["mm_watchpoint1"].push_back(RegData("North_Access", "26", 26, 0x1));
   regDataMap["mm_watchpoint1"].push_back(RegData("East_Access", "27", 27, 0x1));
   regDataMap["mm_watchpoint1"].push_back(RegData("DMA_Access", "28", 28, 0x1));
   regDataMap["mm_watchpoint1"].push_back(RegData("AXI_Access", "29", 29, 0x1));
   regDataMap["mm_watchpoint1"].push_back(RegData("Write_Access", "30", 30, 0x1));
   regDataMap["mm_watchpoint1"].push_back(RegData("Read_Access", "31", 31, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock0_State", "0", 0, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock0_Value", "1", 1, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock5_State", "10", 10, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock5_Value", "11", 11, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock6_State", "12", 12, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock6_Value", "13", 13, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock7_State", "14", 14, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock7_Value", "15", 15, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock8_State", "16", 16, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock8_Value", "17", 17, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock9_State", "18", 18, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock9_Value", "19", 19, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock1_State", "2", 2, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock10_State", "20", 20, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock10_Value", "21", 21, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock11_State", "22", 22, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock11_Value", "23", 23, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock12_State", "24", 24, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock12_Value", "25", 25, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock13_State", "26", 26, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock13_Value", "27", 27, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock14_State", "28", 28, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock14_Value", "29", 29, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock1_Value", "3", 3, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock15_State", "30", 30, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock15_Value", "31", 31, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock2_State", "4", 4, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock2_Value", "5", 5, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock3_State", "6", 6, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock3_Value", "7", 7, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock4_State", "8", 8, 0x1));
   regDataMap["shim_all_lock_state_value"].push_back(RegData("Lock4_Value", "9", 9, 0x1));
   regDataMap["shim_bisr_cache_ctrl"].push_back(RegData("Trigger", "0", 0, 0x1));
   regDataMap["shim_bisr_cache_ctrl"].push_back(RegData("Clear", "4", 4, 0x1));
   regDataMap["shim_bisr_cache_data0"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_cache_data1"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_cache_data2"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_cache_data3"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_cache_status"].push_back(RegData("Done", "0", 0, 0x1));
   regDataMap["shim_bisr_cache_status"].push_back(RegData("Pass", "1", 1, 0x1));
   regDataMap["shim_bisr_test_data0"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_test_data1"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_test_data2"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_test_data3"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_cssd_trigger"].push_back(RegData("Trigger", "0", 0, 0x1));
   regDataMap["shim_combo_event_control"].push_back(RegData("combo2", "17:16", 16, 0x3));
   regDataMap["shim_combo_event_control"].push_back(RegData("combo0", "1:0", 0, 0x3));
   regDataMap["shim_combo_event_control"].push_back(RegData("combo1", "9:8", 8, 0x3));
   regDataMap["shim_combo_event_inputs"].push_back(RegData("eventB", "14:8", 8, 0x7F));
   regDataMap["shim_combo_event_inputs"].push_back(RegData("eventC", "22:16", 16, 0x7F));
   regDataMap["shim_combo_event_inputs"].push_back(RegData("eventD", "30:24", 24, 0x7F));
   regDataMap["shim_combo_event_inputs"].push_back(RegData("eventA", "6:0", 0, 0x7F));
   regDataMap["shim_control_packet_handler_status"].push_back(RegData("Control_Pkt_Error", "0", 0, 0x1));
   regDataMap["shim_dma_mm2s_0_ctrl"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["shim_dma_mm2s_0_ctrl"].push_back(RegData("Pause_Mem", "1", 1, 0x1));
   regDataMap["shim_dma_mm2s_0_ctrl"].push_back(RegData("Pause_Stream", "2", 2, 0x1));
   regDataMap["shim_dma_mm2s_0_start_queue"].push_back(RegData("Start_BD", "3:0", 0, 0xF));
   regDataMap["shim_dma_mm2s_1_ctrl"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["shim_dma_mm2s_1_ctrl"].push_back(RegData("Pause_Mem", "1", 1, 0x1));
   regDataMap["shim_dma_mm2s_1_ctrl"].push_back(RegData("Pause_Stream", "2", 2, 0x1));
   regDataMap["shim_dma_mm2s_1_start_queue"].push_back(RegData("Start_BD", "3:0", 0, 0xF));
   regDataMap["shim_dma_mm2s_status"].push_back(RegData("Start_Queue_Size_1", "11:9", 9, 0x7));
   regDataMap["shim_dma_mm2s_status"].push_back(RegData("Cur_BD_0", "19:16", 16, 0xF));
   regDataMap["shim_dma_mm2s_status"].push_back(RegData("Status0", "1:0", 0, 0x3));
   regDataMap["shim_dma_mm2s_status"].push_back(RegData("Cur_BD_1", "23:20", 20, 0xF));
   regDataMap["shim_dma_mm2s_status"].push_back(RegData("AXI_MM_Decode_Error_0", "24", 24, 0x1));
   regDataMap["shim_dma_mm2s_status"].push_back(RegData("AXI_MM_Decode_Error_1", "25", 25, 0x1));
   regDataMap["shim_dma_mm2s_status"].push_back(RegData("AXI_MM_Slave_Error_0", "26", 26, 0x1));
   regDataMap["shim_dma_mm2s_status"].push_back(RegData("AXI_MM_Slave_Error_1", "27", 27, 0x1));
   regDataMap["shim_dma_mm2s_status"].push_back(RegData("Start_Queue_Overflow_0", "28", 28, 0x1));
   regDataMap["shim_dma_mm2s_status"].push_back(RegData("Start_Queue_Overflow_1", "29", 29, 0x1));
   regDataMap["shim_dma_mm2s_status"].push_back(RegData("Status1", "3:2", 2, 0x3));
   regDataMap["shim_dma_mm2s_status"].push_back(RegData("Stalled0", "4", 4, 0x1));
   regDataMap["shim_dma_mm2s_status"].push_back(RegData("Stalled1", "5", 5, 0x1));
   regDataMap["shim_dma_mm2s_status"].push_back(RegData("Start_Queue_Size_0", "8:6", 6, 0x7));
   regDataMap["shim_dma_s2mm_0_ctrl"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["shim_dma_s2mm_0_ctrl"].push_back(RegData("Pause_Mem", "1", 1, 0x1));
   regDataMap["shim_dma_s2mm_0_ctrl"].push_back(RegData("Pause_Stream", "2", 2, 0x1));
   regDataMap["shim_dma_s2mm_0_start_queue"].push_back(RegData("Start_BD", "3:0", 0, 0xF));
   regDataMap["shim_dma_s2mm_1_ctrl"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["shim_dma_s2mm_1_ctrl"].push_back(RegData("Pause_Mem", "1", 1, 0x1));
   regDataMap["shim_dma_s2mm_1_ctrl"].push_back(RegData("Pause_Stream", "2", 2, 0x1));
   regDataMap["shim_dma_s2mm_1_start_queue"].push_back(RegData("Start_BD", "3:0", 0, 0xF));
   regDataMap["shim_dma_s2mm_status"].push_back(RegData("Start_Queue_Size_1", "11:9", 9, 0x7));
   regDataMap["shim_dma_s2mm_status"].push_back(RegData("Cur_BD_0", "19:16", 16, 0xF));
   regDataMap["shim_dma_s2mm_status"].push_back(RegData("Status0", "1:0", 0, 0x3));
   regDataMap["shim_dma_s2mm_status"].push_back(RegData("Cur_BD_1", "23:20", 20, 0xF));
   regDataMap["shim_dma_s2mm_status"].push_back(RegData("AXI_MM_Decode_Error_0", "24", 24, 0x1));
   regDataMap["shim_dma_s2mm_status"].push_back(RegData("AXI_MM_Decode_Error_1", "25", 25, 0x1));
   regDataMap["shim_dma_s2mm_status"].push_back(RegData("AXI_MM_Slave_Error_0", "26", 26, 0x1));
   regDataMap["shim_dma_s2mm_status"].push_back(RegData("AXI_MM_Slave_Error_1", "27", 27, 0x1));
   regDataMap["shim_dma_s2mm_status"].push_back(RegData("Start_Queue_Overflow_0", "28", 28, 0x1));
   regDataMap["shim_dma_s2mm_status"].push_back(RegData("Start_Queue_Overflow_1", "29", 29, 0x1));
   regDataMap["shim_dma_s2mm_status"].push_back(RegData("Status1", "3:2", 2, 0x3));
   regDataMap["shim_dma_s2mm_status"].push_back(RegData("Stalled0", "4", 4, 0x1));
   regDataMap["shim_dma_s2mm_status"].push_back(RegData("Stalled1", "5", 5, 0x1));
   regDataMap["shim_dma_s2mm_status"].push_back(RegData("Start_Queue_Size_0", "8:6", 6, 0x7));
   regDataMap["shim_demux_config"].push_back(RegData("South5", "11:10", 10, 0x3));
   regDataMap["shim_demux_config"].push_back(RegData("South2", "5:4", 4, 0x3));
   regDataMap["shim_demux_config"].push_back(RegData("South3", "7:6", 6, 0x3));
   regDataMap["shim_demux_config"].push_back(RegData("South4", "9:8", 8, 0x3));
   regDataMap["shim_event_broadcast0_a"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_broadcast10_a"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_broadcast11_a"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_broadcast12_a"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_broadcast13_a"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_broadcast14_a"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_broadcast15_a"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_broadcast1_a"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_broadcast2_a"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_broadcast3_a"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_broadcast4_a"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_broadcast5_a"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_broadcast6_a"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_broadcast7_a"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_broadcast8_a"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_broadcast9_a"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_broadcast_a_block_east_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_east_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_east_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_north_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_north_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_north_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_south_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_south_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_south_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_west_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_west_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_west_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_east_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_east_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_east_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_north_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_north_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_north_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_south_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_south_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_south_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_west_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_west_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_west_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_generate"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Timer_Sync", "0", 0, 0x1));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Timer_Value_Reached", "1", 1, 0x1));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Perf_Cnt0", "2", 2, 0x1));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Perf_Cnt1", "3", 3, 0x1));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Combo_Event_0", "4", 4, 0x1));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Combo_Event_1", "5", 5, 0x1));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Combo_Event_2", "6", 6, 0x1));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Combo_Event_3", "7", 7, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_0", "0", 0, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_1", "1", 1, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_10", "10", 10, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_11", "11", 11, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_12", "12", 12, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_13", "13", 13, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_14", "14", 14, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_15", "15", 15, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_2", "2", 2, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_3", "3", 3, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_4", "4", 4, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_5", "5", 5, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_6", "6", 6, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_7", "7", 7, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_8", "8", 8, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_9", "9", 9, 0x1));
   regDataMap["shim_event_group_dma_activity_enable"].push_back(RegData("DMA_S2MM_0_start_BD", "0", 0, 0x1));
   regDataMap["shim_event_group_dma_activity_enable"].push_back(RegData("DMA_S2MM_1_start_BD", "1", 1, 0x1));
   regDataMap["shim_event_group_dma_activity_enable"].push_back(RegData("DMA_MM2S_0_go_to_idle", "10", 10, 0x1));
   regDataMap["shim_event_group_dma_activity_enable"].push_back(RegData("DMA_MM2S_1_go_to_idle", "11", 11, 0x1));
   regDataMap["shim_event_group_dma_activity_enable"].push_back(RegData("DMA_S2MM_0_stalled_lock_acquire", "12", 12, 0x1));
   regDataMap["shim_event_group_dma_activity_enable"].push_back(RegData("DMA_S2MM_1_stalled_lock_acquire", "13", 13, 0x1));
   regDataMap["shim_event_group_dma_activity_enable"].push_back(RegData("DMA_MM2S_0_stalled_lock_acquire", "14", 14, 0x1));
   regDataMap["shim_event_group_dma_activity_enable"].push_back(RegData("DMA_MM2S_1_stalled_lock_acquire", "15", 15, 0x1));
   regDataMap["shim_event_group_dma_activity_enable"].push_back(RegData("DMA_MM2S_0_start_BD", "2", 2, 0x1));
   regDataMap["shim_event_group_dma_activity_enable"].push_back(RegData("DMA_MM2S_1_start_BD", "3", 3, 0x1));
   regDataMap["shim_event_group_dma_activity_enable"].push_back(RegData("DMA_S2MM_0_finished_BD", "4", 4, 0x1));
   regDataMap["shim_event_group_dma_activity_enable"].push_back(RegData("DMA_S2MM_1_finished_BD", "5", 5, 0x1));
   regDataMap["shim_event_group_dma_activity_enable"].push_back(RegData("DMA_MM2S_0_finished_BD", "6", 6, 0x1));
   regDataMap["shim_event_group_dma_activity_enable"].push_back(RegData("DMA_MM2S_1_finished_BD", "7", 7, 0x1));
   regDataMap["shim_event_group_dma_activity_enable"].push_back(RegData("DMA_S2MM_0_go_to_idle", "8", 8, 0x1));
   regDataMap["shim_event_group_dma_activity_enable"].push_back(RegData("DMA_S2MM_1_go_to_idle", "9", 9, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("AXI_MM_Slave_Tile_Error", "0", 0, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("Control_Pkt_Error", "1", 1, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("DMA_MM2S_1_Error", "10", 10, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("AXI_MM_Decode_NSU_Error", "2", 2, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("AXI_MM_Slave_NSU_Error", "3", 3, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("AXI_MM_Unsupported_Traffic", "4", 4, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("AXI_MM_Unsecure_Access_in_Secure_Mode", "5", 5, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("AXI_MM_Byte_Strobe_Error", "6", 6, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("DMA_S2MM_0_Error", "7", 7, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("DMA_S2MM_1_Error", "8", 8, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("DMA_MM2S_0_Error", "9", 9, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_0_Acquired", "0", 0, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_0_Release", "1", 1, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_5_Acquired", "10", 10, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_5_Release", "11", 11, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_6_Acquired", "12", 12, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_6_Release", "13", 13, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_7_Acquired", "14", 14, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_7_Release", "15", 15, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_8_Acquired", "16", 16, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_8_Release", "17", 17, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_9_Acquired", "18", 18, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_9_Release", "19", 19, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_1_Acquired", "2", 2, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_10_Acquired", "20", 20, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_10_Release", "21", 21, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_11_Acquired", "22", 22, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_11_Release", "23", 23, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_12_Acquired", "24", 24, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_12_Release", "25", 25, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_13_Acquired", "26", 26, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_13_Release", "27", 27, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_14_Acquired", "28", 28, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_14_Release", "29", 29, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_1_Release", "3", 3, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_15_Acquired", "30", 30, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_15_Release", "31", 31, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_2_Acquired", "4", 4, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_2_Release", "5", 5, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_3_Acquired", "6", 6, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_3_Release", "7", 7, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_4_Acquired", "8", 8, 0x1));
   regDataMap["shim_event_group_lock_enable"].push_back(RegData("Lock_4_Release", "9", 9, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_0", "0", 0, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Running_0", "1", 1, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_2", "10", 10, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_2", "11", 11, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_3", "12", 12, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Running_3", "13", 13, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_3", "14", 14, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_3", "15", 15, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_4", "16", 16, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Running_4", "17", 17, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_4", "18", 18, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_4", "19", 19, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_0", "2", 2, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_5", "20", 20, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Running_5", "21", 21, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_5", "22", 22, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_5", "23", 23, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_6", "24", 24, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Running_6", "25", 25, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_6", "26", 26, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_6", "27", 27, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_7", "28", 28, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Running_7", "29", 29, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_0", "3", 3, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_7", "30", 30, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_7", "31", 31, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_1", "4", 4, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Running_1", "5", 5, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_1", "6", 6, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_1", "7", 7, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_2", "8", 8, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Running_2", "9", 9, 0x1));
   regDataMap["shim_event_group_user_enable"].push_back(RegData("User_Event_0", "0", 0, 0x1));
   regDataMap["shim_event_group_user_enable"].push_back(RegData("User_Event_1", "1", 1, 0x1));
   regDataMap["shim_event_group_user_enable"].push_back(RegData("User_Event_2", "2", 2, 0x1));
   regDataMap["shim_event_group_user_enable"].push_back(RegData("User_Event_3", "3", 3, 0x1));
   regDataMap["shim_event_status0"].push_back(RegData("Event_31_0_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_event_status1"].push_back(RegData("Event_63_32_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_event_status2"].push_back(RegData("Event_95_64_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_event_status3"].push_back(RegData("Event_127_96_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_interrupt_controller_1st_level_block_north_in_a_clear"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_1st_level_block_north_in_a_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_1st_level_block_north_in_a_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_1st_level_block_north_in_b_clear"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_1st_level_block_north_in_b_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_1st_level_block_north_in_b_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_1st_level_disable_a"].push_back(RegData("Disable_A", "19:0", 0, 0xFFFFF));
   regDataMap["shim_interrupt_controller_1st_level_disable_b"].push_back(RegData("Disable_B", "19:0", 0, 0xFFFFF));
   regDataMap["shim_interrupt_controller_1st_level_enable_a"].push_back(RegData("Enable_A", "19:0", 0, 0xFFFFF));
   regDataMap["shim_interrupt_controller_1st_level_enable_b"].push_back(RegData("Enable_B", "19:0", 0, 0xFFFFF));
   regDataMap["shim_interrupt_controller_1st_level_irq_event_a"].push_back(RegData("IRQ_Event1", "14:8", 8, 0x7F));
   regDataMap["shim_interrupt_controller_1st_level_irq_event_a"].push_back(RegData("IRQ_Event2", "22:16", 16, 0x7F));
   regDataMap["shim_interrupt_controller_1st_level_irq_event_a"].push_back(RegData("IRQ_Event3", "30:24", 24, 0x7F));
   regDataMap["shim_interrupt_controller_1st_level_irq_event_a"].push_back(RegData("IRQ_Event0", "6:0", 0, 0x7F));
   regDataMap["shim_interrupt_controller_1st_level_irq_event_b"].push_back(RegData("IRQ_Event1", "14:8", 8, 0x7F));
   regDataMap["shim_interrupt_controller_1st_level_irq_event_b"].push_back(RegData("IRQ_Event2", "22:16", 16, 0x7F));
   regDataMap["shim_interrupt_controller_1st_level_irq_event_b"].push_back(RegData("IRQ_Event3", "30:24", 24, 0x7F));
   regDataMap["shim_interrupt_controller_1st_level_irq_event_b"].push_back(RegData("IRQ_Event0", "6:0", 0, 0x7F));
   regDataMap["shim_interrupt_controller_1st_level_irq_no_a"].push_back(RegData("Irq_no_A", "3:0", 0, 0xF));
   regDataMap["shim_interrupt_controller_1st_level_irq_no_b"].push_back(RegData("Irq_no_B", "3:0", 0, 0xF));
   regDataMap["shim_interrupt_controller_1st_level_mask_a"].push_back(RegData("IRQ_Mask_A", "19:0", 0, 0xFFFFF));
   regDataMap["shim_interrupt_controller_1st_level_mask_b"].push_back(RegData("IRQ_Mask_B", "19:0", 0, 0xFFFFF));
   regDataMap["shim_interrupt_controller_1st_level_status_a"].push_back(RegData("Status_A", "19:0", 0, 0xFFFFF));
   regDataMap["shim_interrupt_controller_1st_level_status_b"].push_back(RegData("Status_B", "19:0", 0, 0xFFFFF));
   regDataMap["shim_interrupt_controller_2nd_level_disable"].push_back(RegData("Disable_A", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_2nd_level_enable"].push_back(RegData("Enable_A", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_2nd_level_interrupt"].push_back(RegData("NoC_Interrupt", "1:0", 0, 0x3));
   regDataMap["shim_interrupt_controller_2nd_level_mask"].push_back(RegData("IRQ_Mask_A", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_2nd_level_status"].push_back(RegData("Status_A", "15:0", 0, 0xFFFF));
   regDataMap["shim_lock0_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock0_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock0_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock0_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock0_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock0_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock10_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock10_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock10_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock10_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock10_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock10_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock11_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock11_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock11_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock11_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock11_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock11_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock12_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock12_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock12_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock12_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock12_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock12_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock13_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock13_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock13_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock13_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock13_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock13_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock14_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock14_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock14_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock14_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock14_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock14_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock15_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock15_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock15_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock15_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock15_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock15_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock1_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock1_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock1_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock1_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock1_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock1_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock2_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock2_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock2_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock2_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock2_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock2_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock3_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock3_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock3_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock3_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock3_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock3_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock4_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock4_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock4_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock4_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock4_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock4_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock5_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock5_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock5_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock5_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock5_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock5_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock6_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock6_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock6_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock6_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock6_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock6_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock7_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock7_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock7_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock7_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock7_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock7_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock8_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock8_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock8_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock8_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock8_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock8_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock9_acquire_nv"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock9_acquire_v0"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock9_acquire_v1"].push_back(RegData("Acquire_Done", "0", 0, 0x1));
   regDataMap["shim_lock9_release_nv"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock9_release_v0"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock9_release_v1"].push_back(RegData("Release_Done", "0", 0, 0x1));
   regDataMap["shim_lock_event_value_control_0"].push_back(RegData("Lock_2_Release", "11:10", 10, 0x3));
   regDataMap["shim_lock_event_value_control_0"].push_back(RegData("Lock_3_Acquired", "13:12", 12, 0x3));
   regDataMap["shim_lock_event_value_control_0"].push_back(RegData("Lock_3_Release", "15:14", 14, 0x3));
   regDataMap["shim_lock_event_value_control_0"].push_back(RegData("Lock_4_Acquired", "17:16", 16, 0x3));
   regDataMap["shim_lock_event_value_control_0"].push_back(RegData("Lock_4_Release", "19:18", 18, 0x3));
   regDataMap["shim_lock_event_value_control_0"].push_back(RegData("Lock_0_Acquired", "1:0", 0, 0x3));
   regDataMap["shim_lock_event_value_control_0"].push_back(RegData("Lock_5_Acquired", "21:20", 20, 0x3));
   regDataMap["shim_lock_event_value_control_0"].push_back(RegData("Lock_5_Release", "23:22", 22, 0x3));
   regDataMap["shim_lock_event_value_control_0"].push_back(RegData("Lock_6_Acquired", "25:24", 24, 0x3));
   regDataMap["shim_lock_event_value_control_0"].push_back(RegData("Lock_6_Release", "27:26", 26, 0x3));
   regDataMap["shim_lock_event_value_control_0"].push_back(RegData("Lock_7_Acquired", "29:28", 28, 0x3));
   regDataMap["shim_lock_event_value_control_0"].push_back(RegData("Lock_7_Release", "31:30", 30, 0x3));
   regDataMap["shim_lock_event_value_control_0"].push_back(RegData("Lock_0_Release", "3:2", 2, 0x3));
   regDataMap["shim_lock_event_value_control_0"].push_back(RegData("Lock_1_Acquired", "5:4", 4, 0x3));
   regDataMap["shim_lock_event_value_control_0"].push_back(RegData("Lock_1_Release", "7:6", 6, 0x3));
   regDataMap["shim_lock_event_value_control_0"].push_back(RegData("Lock_2_Acquired", "9:8", 8, 0x3));
   regDataMap["shim_lock_event_value_control_1"].push_back(RegData("Lock_10_Release", "11:10", 10, 0x3));
   regDataMap["shim_lock_event_value_control_1"].push_back(RegData("Lock_11_Acquired", "13:12", 12, 0x3));
   regDataMap["shim_lock_event_value_control_1"].push_back(RegData("Lock_11_Release", "15:14", 14, 0x3));
   regDataMap["shim_lock_event_value_control_1"].push_back(RegData("Lock_12_Acquired", "17:16", 16, 0x3));
   regDataMap["shim_lock_event_value_control_1"].push_back(RegData("Lock_12_Release", "19:18", 18, 0x3));
   regDataMap["shim_lock_event_value_control_1"].push_back(RegData("Lock_8_Acquired", "1:0", 0, 0x3));
   regDataMap["shim_lock_event_value_control_1"].push_back(RegData("Lock_13_Acquired", "21:20", 20, 0x3));
   regDataMap["shim_lock_event_value_control_1"].push_back(RegData("Lock_13_Release", "23:22", 22, 0x3));
   regDataMap["shim_lock_event_value_control_1"].push_back(RegData("Lock_14_Acquired", "25:24", 24, 0x3));
   regDataMap["shim_lock_event_value_control_1"].push_back(RegData("Lock_14_Release", "27:26", 26, 0x3));
   regDataMap["shim_lock_event_value_control_1"].push_back(RegData("Lock_15_Acquired", "29:28", 28, 0x3));
   regDataMap["shim_lock_event_value_control_1"].push_back(RegData("Lock_15_Release", "31:30", 30, 0x3));
   regDataMap["shim_lock_event_value_control_1"].push_back(RegData("Lock_8_Release", "3:2", 2, 0x3));
   regDataMap["shim_lock_event_value_control_1"].push_back(RegData("Lock_9_Acquired", "5:4", 4, 0x3));
   regDataMap["shim_lock_event_value_control_1"].push_back(RegData("Lock_9_Release", "7:6", 6, 0x3));
   regDataMap["shim_lock_event_value_control_1"].push_back(RegData("Lock_10_Acquired", "9:8", 8, 0x3));
   regDataMap["shim_me_aximm_config"].push_back(RegData("Master_Sel", "0", 0, 0x1));
   regDataMap["shim_me_aximm_config"].push_back(RegData("Slave_Sel", "1", 1, 0x1));
   regDataMap["shim_me_aximm_config"].push_back(RegData("SLVERR_Block", "2", 2, 0x1));
   regDataMap["shim_me_aximm_config"].push_back(RegData("DECERR_Block", "3", 3, 0x1));
   regDataMap["shim_me_aximm_config"].push_back(RegData("reserved", "4", 4, 0x1));
   regDataMap["shim_me_aximm_config"].push_back(RegData("reserved", "5", 5, 0x1));
   regDataMap["shim_me_shim_reset_enable"].push_back(RegData("Reset", "0", 0, 0x1));
   regDataMap["shim_me_tile_column_reset"].push_back(RegData("Reset", "0", 0, 0x1));
   regDataMap["shim_mux_config"].push_back(RegData("South3", "11:10", 10, 0x3));
   regDataMap["shim_mux_config"].push_back(RegData("South6", "13:12", 12, 0x3));
   regDataMap["shim_mux_config"].push_back(RegData("South7", "15:14", 14, 0x3));
   regDataMap["shim_mux_config"].push_back(RegData("South2", "9:8", 8, 0x3));
   regDataMap["shim_noc_interface_me_to_noc_south2"].push_back(RegData("reserved", "21:10", 10, 0xFFF));
   regDataMap["shim_noc_interface_me_to_noc_south2"].push_back(RegData("Tdest", "9:0", 0, 0x3FF));
   regDataMap["shim_noc_interface_me_to_noc_south3"].push_back(RegData("reserved", "21:10", 10, 0xFFF));
   regDataMap["shim_noc_interface_me_to_noc_south3"].push_back(RegData("Tdest", "9:0", 0, 0x3FF));
   regDataMap["shim_noc_interface_me_to_noc_south4"].push_back(RegData("reserved", "21:10", 10, 0xFFF));
   regDataMap["shim_noc_interface_me_to_noc_south4"].push_back(RegData("Tdest", "9:0", 0, 0x3FF));
   regDataMap["shim_noc_interface_me_to_noc_south5"].push_back(RegData("reserved", "21:10", 10, 0xFFF));
   regDataMap["shim_noc_interface_me_to_noc_south5"].push_back(RegData("Tdest", "9:0", 0, 0x3FF));
   regDataMap["shim_pl_interface_downsizer_bypass"].push_back(RegData("South0", "0", 0, 0x1));
   regDataMap["shim_pl_interface_downsizer_bypass"].push_back(RegData("South1", "1", 1, 0x1));
   regDataMap["shim_pl_interface_downsizer_bypass"].push_back(RegData("South2", "2", 2, 0x1));
   regDataMap["shim_pl_interface_downsizer_bypass"].push_back(RegData("South4", "3", 3, 0x1));
   regDataMap["shim_pl_interface_downsizer_bypass"].push_back(RegData("South5", "4", 4, 0x1));
   regDataMap["shim_pl_interface_downsizer_bypass"].push_back(RegData("South6", "5", 5, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South0", "0", 0, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South1", "1", 1, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South7", "10", 10, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South6_South7_128_combine", "11", 11, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South0_South1_128_combine", "2", 2, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South2", "3", 3, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South3", "4", 4, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South2_South3_128_combine", "5", 5, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South4", "6", 6, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South5", "7", 7, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South4_South5_128_combine", "8", 8, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South6", "9", 9, 0x1));
   regDataMap["shim_pl_interface_downsizer_enable"].push_back(RegData("South0", "0", 0, 0x1));
   regDataMap["shim_pl_interface_downsizer_enable"].push_back(RegData("South1", "1", 1, 0x1));
   regDataMap["shim_pl_interface_downsizer_enable"].push_back(RegData("South2", "2", 2, 0x1));
   regDataMap["shim_pl_interface_downsizer_enable"].push_back(RegData("South3", "3", 3, 0x1));
   regDataMap["shim_pl_interface_downsizer_enable"].push_back(RegData("South4", "4", 4, 0x1));
   regDataMap["shim_pl_interface_downsizer_enable"].push_back(RegData("South5", "5", 5, 0x1));
   regDataMap["shim_pl_interface_downsizer_enable"].push_back(RegData("South6", "6", 6, 0x1));
   regDataMap["shim_pl_interface_downsizer_enable"].push_back(RegData("South7", "7", 7, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South0", "0", 0, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South1", "1", 1, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South0_South1_128_combine", "2", 2, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South2", "3", 3, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South3", "4", 4, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South2_South3_128_combine", "5", 5, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South4", "6", 6, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South5", "7", 7, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South4_South5_128_combine", "8", 8, 0x1));
   regDataMap["shim_performance_counter0"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_performance_counter0_event_value"].push_back(RegData("Counter_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_performance_counter1"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_performance_counter1_event_value"].push_back(RegData("Counter_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_performance_ctrl0"].push_back(RegData("Cnt0_Stop_Event", "14:8", 8, 0x7F));
   regDataMap["shim_performance_ctrl0"].push_back(RegData("Cnt1_Start_Event", "22:16", 16, 0x7F));
   regDataMap["shim_performance_ctrl0"].push_back(RegData("Cnt1_Stop_Event", "30:24", 24, 0x7F));
   regDataMap["shim_performance_ctrl0"].push_back(RegData("Cnt0_Start_Event", "6:0", 0, 0x7F));
   regDataMap["shim_performance_ctrl1"].push_back(RegData("Cnt1_Reset_Event", "14:8", 8, 0x7F));
   regDataMap["shim_performance_ctrl1"].push_back(RegData("Cnt0_Reset_Event", "6:0", 0, 0x7F));
   regDataMap["shim_reserved0"].push_back(RegData("reserved", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_reserved1"].push_back(RegData("reserved", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_reserved2"].push_back(RegData("reserved", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_reserved3"].push_back(RegData("reserved", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_spare_reg"].push_back(RegData("Spare_Reg", "15:0", 0, 0xFFFF));
   regDataMap["shim_spare_reg"].push_back(RegData("Spare_Reg", "15:0", 0, 0xFFFF));
   regDataMap["shim_stream_switch_event_port_selection_0"].push_back(RegData("Port_1_ID", "12:8", 8, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_0"].push_back(RegData("Port_1_Master_Slave", "13", 13, 0x1));
   regDataMap["shim_stream_switch_event_port_selection_0"].push_back(RegData("Port_2_ID", "20:16", 16, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_0"].push_back(RegData("Port_2_Master_Slave", "21", 21, 0x1));
   regDataMap["shim_stream_switch_event_port_selection_0"].push_back(RegData("Port_3_ID", "28:24", 24, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_0"].push_back(RegData("Port_3_Master_Slave", "29", 29, 0x1));
   regDataMap["shim_stream_switch_event_port_selection_0"].push_back(RegData("Port_0_ID", "4:0", 0, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_0"].push_back(RegData("Port_0_Master_Slave", "5", 5, 0x1));
   regDataMap["shim_stream_switch_event_port_selection_1"].push_back(RegData("Port_5_ID", "12:8", 8, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_1"].push_back(RegData("Port_5_Master_Slave", "13", 13, 0x1));
   regDataMap["shim_stream_switch_event_port_selection_1"].push_back(RegData("Port_6_ID", "20:16", 16, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_1"].push_back(RegData("Port_6_Master_Slave", "21", 21, 0x1));
   regDataMap["shim_stream_switch_event_port_selection_1"].push_back(RegData("Port_7_ID", "28:24", 24, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_1"].push_back(RegData("Port_7_Master_Slave", "29", 29, 0x1));
   regDataMap["shim_stream_switch_event_port_selection_1"].push_back(RegData("Port_4_ID", "4:0", 0, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_1"].push_back(RegData("Port_4_Master_Slave", "5", 5, 0x1));
   regDataMap["shim_tile_clock_control"].push_back(RegData("Clock_Buffer_Enable", "0", 0, 0x1));
   regDataMap["shim_tile_clock_control"].push_back(RegData("Next_Tile_Clock_Enable", "1", 1, 0x1));
   regDataMap["shim_tile_control"].push_back(RegData("Isolate_From_South", "0", 0, 0x1));
   regDataMap["shim_tile_control"].push_back(RegData("Isolate_From_West", "1", 1, 0x1));
   regDataMap["shim_tile_control"].push_back(RegData("Isolate_From_North", "2", 2, 0x1));
   regDataMap["shim_tile_control"].push_back(RegData("Isolate_From_East", "3", 3, 0x1));
   regDataMap["shim_timer_control"].push_back(RegData("Reset_Event", "14:8", 8, 0x7F));
   regDataMap["shim_timer_control"].push_back(RegData("Reset", "31", 31, 0x1));
   regDataMap["shim_timer_high"].push_back(RegData("TimerHigh", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_timer_low"].push_back(RegData("TimerLow", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_timer_trig_event_high_value"].push_back(RegData("TimerTrigHigh", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_timer_trig_event_low_value"].push_back(RegData("TimerTrigLow", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_trace_control0"].push_back(RegData("Trace_Start_Event", "22:16", 16, 0x7F));
   regDataMap["shim_trace_control0"].push_back(RegData("Trace_Stop_Event", "30:24", 24, 0x7F));
   regDataMap["shim_trace_control1"].push_back(RegData("Packet_Type", "14:12", 12, 0x7));
   regDataMap["shim_trace_control1"].push_back(RegData("ID", "4:0", 0, 0x1F));
   regDataMap["shim_trace_event0"].push_back(RegData("Trace_Event1", "14:8", 8, 0x7F));
   regDataMap["shim_trace_event0"].push_back(RegData("Trace_Event2", "22:16", 16, 0x7F));
   regDataMap["shim_trace_event0"].push_back(RegData("Trace_Event3", "30:24", 24, 0x7F));
   regDataMap["shim_trace_event0"].push_back(RegData("Trace_Event0", "6:0", 0, 0x7F));
   regDataMap["shim_trace_event1"].push_back(RegData("Trace_Event5", "14:8", 8, 0x7F));
   regDataMap["shim_trace_event1"].push_back(RegData("Trace_Event6", "22:16", 16, 0x7F));
   regDataMap["shim_trace_event1"].push_back(RegData("Trace_Event7", "30:24", 24, 0x7F));
   regDataMap["shim_trace_event1"].push_back(RegData("Trace_Event4", "6:0", 0, 0x7F));
   regDataMap["shim_trace_status"].push_back(RegData("Mode", "2:0", 0, 0x7));
   regDataMap["shim_trace_status"].push_back(RegData("State", "9:8", 8, 0x3));
}

} // end namespace xdp
